/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.dropper;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.dropper.ContainerDropper;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDropper
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private ItemStackHandler inventory = new ItemStackHandler(1);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    ItemStackHandler gpsSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private int dropCount = 1;
    private int delay = 10;

    public TileDropper(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.DROPPER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileDropper e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileDropper e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        --this.timer;
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        ItemStack dropMe = this.inventory.getStackInSlot(0).m_41777_();
        BlockPos target = this.getTargetPos();
        int amtDrop = Math.min(this.dropCount, dropMe.m_41613_());
        if (amtDrop > 0) {
            this.energy.extractEnergy(cost, false);
            dropMe.m_41764_(amtDrop);
            UtilItemStack.dropItemStackMotionless(this.f_58857_, target, dropMe);
            this.inventory.getStackInSlot(0).m_41774_(amtDrop);
        }
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerDropper(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.gpsSlots.deserializeNBT(tag.m_128469_("invgps"));
        this.delay = tag.m_128451_("delay");
        this.dropCount = tag.m_128451_("dropCount");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("invgps", (Tag)this.gpsSlots.serializeNBT());
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("dropCount", this.dropCount);
        super.m_183515_(tag);
    }

    private BlockPos getTargetPos() {
        BlockPosDim loc = LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(0));
        if (loc != null && UtilWorld.dimensionIsEqual(loc, this.f_58857_)) {
            return loc.getPos();
        }
        return this.getCurrentFacingPos().m_5484_(this.getCurrentFacing(), 1);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case DELAY: {
                return this.delay;
            }
            case DROPCOUNT: {
                return this.dropCount;
            }
            case RENDER: {
                return this.render;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case DELAY: {
                this.delay = Math.max(0, value);
                break;
            }
            case DROPCOUNT: {
                this.dropCount = Math.max(1, value);
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    public List<BlockPos> getShape() {
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        shape.add(this.getTargetPos());
        return shape;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        DROPCOUNT,
        DELAY,
        RENDER;

    }
}

